<?php
class Lighthouselog
{

    protected $project_id = '';
    protected $deliverable_id = '';
    protected $log_endpoint = '';

    public $systemTags = [];
    public $payload = [];

    const severityType = [
        'debug',
        'warning',
        'notice',
        'info',
        'error'
    ];

    public $error_types = [
        1 => 'debug',
        2 => 'warning',
        3 => 'notice',
        4 => 'info',
        5 => 'error',
    ];

    public function __construct()
    {
        $this->project_id = get_option('lighthouse_project_id');
        $this->deliverable_id = get_option('lighthouse_deliverable_id');
        $this->log_endpoint = "https://api.huntglitch.com/add-log";

        $st = $this->systemTags;
        $this->systemTags = $this->generateTags();
    }

    public function addError($data, array $additionalData = [])
    {
        return $this->add($data, 'error', $additionalData);
    }

    public function addWarning($data, array $additionalData = [])
    {
        return $this->add($data, 'warning', $additionalData);
    }

    public function addInfo($data, array $additionalData = [])
    {
        return $this->add($data, 'info', $additionalData);
    }

    public function addDebug($data, array $additionalData = [])
    {
        return $this->add($data, 'debug', $additionalData);
    }

    public function addNotice($data, array $additionalData = [])
    {
        return $this->add($data, 'notice', $additionalData);
    }

    public function add($data, $errorType = '', array $additionalData = [])
    {


        if ($this->project_id == '') {
            return 'Project Key Not Found';
        }


        if ($this->deliverable_id == '') {
            return 'Deliverable Key Not Found';
        }


        $payload = [];
        $payloadsData = [];

        if ($data instanceof \Throwable) {
            $payloadsData['b'] = $this->getErrorData($data);
        } else {
            $payloadsData['b']['c'] = (string) $data;
        }

        if ($errorType == '' && $data instanceof \ErrorException) {
            $type =  $this->getErrorTypeFromException($data->getSeverity());
        } else {
            $type = $this->getErrorTypeFromString($errorType);
        }

        if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on')
            $url = "https://";
        else
            $url = "http://";
        // Append the host(domain name, ip) to the URL.   
        $url .= $_SERVER['HTTP_HOST'];

        // Append the requested resource location to the URL   
        $url .= $_SERVER['REQUEST_URI'];

        $payloadsData['i'] = $additionalData;
        $payloadsData['j'] =  $this->systemTags;
        $payloadsData['k'] = getallheaders();
        $payloadsData['l'] =  array_merge($_GET, $_POST);
        $payloadsData['m'] =  $url;
        $payloadsData['n'] = $_SERVER['REQUEST_METHOD'];

        $payload = [
            'vp' => $this->project_id,
            'vd' => $this->deliverable_id,
            'o' => $type,
            'a' => json_encode($payloadsData), // a means data
            'r' =>  $this->getUserIP()
        ];

        $result = $this->sendPayload($payload);
        return $result;
    }
    protected function sendPayload(array $post_payload)
    {
        try {

            $baseUrl = $this->log_endpoint;


            $ch = curl_init($baseUrl);
            curl_setopt($ch, CURLOPT_POSTFIELDS,  json_encode($post_payload));
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            return $result;
        } catch (Throwable $e) {

            return 'Log Connection Error';
        } catch (\Exception $e) {

            return 'Log Connection Error';
        }
    }

    protected function getErrorData(\Throwable $e)
    {

        $errorData = [];

        if ($e != null) {

            $traceData = [];

            foreach ($e->getTrace() as $trace) {
                if (isset($trace['file']) && isset($trace['line'])) {
                    $data = $this->getFileContent(5, $trace['file'], $trace['line']);
                    $data['lineno'] = $trace['line'];
                    $data['file'] = $trace['file'];
                    $traceData[] = $data;
                }
            }

            $errorData = [
                'c' => $e->getMessage(),
                'd' => $e->getFile(),
                'e' => $traceData,
                'f' => $e->getLine(),
                'g' => $e->getCode(),
                'h' => get_class($e)
            ];
        }


        return $errorData;
    }
    protected function getFileContent(int $maxContextLines, string $filePath, int $lineNumber)
    {

        $frame = [
            'pre_context' => [],
            'context_line' => null,
            'post_context' => [],
        ];

        $target = max(0, ($lineNumber - ($maxContextLines + 1)));
        $currentLineNumber = $target + 1;

        try {
            $file = new \SplFileObject($filePath);
            $file->seek($target);

            while (!$file->eof()) {

                $line = $file->current();
                $line = rtrim($line, "\r\n");

                if ($currentLineNumber === $lineNumber) {
                    $frame['context_line'] = $line;
                } elseif ($currentLineNumber < $lineNumber) {
                    $frame['pre_context'][] = $line;
                } elseif ($currentLineNumber > $lineNumber) {
                    $frame['post_context'][] = $line;
                }

                ++$currentLineNumber;

                if ($currentLineNumber > $lineNumber + $maxContextLines) {
                    break;
                }

                $file->next();
            }
        } catch (\Exception $e) {

            return $frame;
        }

        return $frame;
    }

    function getSourceCodeExcerpt(int $maxContextLines, string $filePath, int $lineNumber)
    {

        $frame = [
            'pre_context' => [],
            'context_line' => null,
            'post_context' => [],
        ];

        $target = max(0, ($lineNumber - ($maxContextLines + 1)));
        $currentLineNumber = $target + 1;

        try {
            $file = new \SplFileObject($filePath);
            $file->seek($target);

            while (!$file->eof()) {

                $line = $file->current();
                $line = rtrim($line, "\r\n");

                if ($currentLineNumber === $lineNumber) {
                    $frame['context_line'] = $line;
                } elseif ($currentLineNumber < $lineNumber) {
                    $frame['pre_context'][] = $line;
                } elseif ($currentLineNumber > $lineNumber) {
                    $frame['post_context'][] = $line;
                }

                ++$currentLineNumber;

                if ($currentLineNumber > $lineNumber + $maxContextLines) {
                    break;
                }

                $file->next();
            }
        } catch (\Exception $e) {

            return $frame;
        }

        return $frame;
    }
    public function generateTags()
    {
        $tags = $this->getBrowserInfo();
        $tags['logger'] = 'php';
        $tags['php-version'] = phpversion();

        return $tags;
    }
    function getBrowserInfo()
    {

        $u_agent = $_SERVER['HTTP_USER_AGENT'];

        $bname = 'Unknown';
        $platform = 'Unknown';
        $version = "";

        //First get the platform?
        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        } elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        } elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }

        // Next get the name of the useragent yes seperately and for good reason
        if (preg_match('/MSIE/i', $u_agent) && !preg_match('/Opera/i', $u_agent)) {
            $bname = 'Internet Explorer';
            $ub = "MSIE";
        } elseif (preg_match('/Firefox/i', $u_agent)) {
            $bname = 'Mozilla Firefox';
            $ub = "Firefox";
        } elseif (preg_match('/OPR/i', $u_agent)) {
            $bname = 'Opera';
            $ub = "Opera";
        } elseif (preg_match('/Chrome/i', $u_agent) && !preg_match('/Edge/i', $u_agent) && !preg_match('/Edg/i', $u_agent)) {
            $bname = 'Google Chrome';
            $ub = "Chrome";
        } elseif (preg_match('/Safari/i', $u_agent) && !preg_match('/Edge/i', $u_agent) && !preg_match('/Edg/i', $u_agent)) {
            $bname = 'Apple Safari';
            $ub = "Safari";
        } elseif (preg_match('/Netscape/i', $u_agent)) {
            $bname = 'Netscape';
            $ub = "Netscape";
        } elseif (preg_match('/Edge/i', $u_agent)) {
            $bname = 'Edge';
            $ub = "Edge";
        } elseif (preg_match('/Edg/i', $u_agent)) {
            $bname = 'Edg';
            $ub = "Edg";
        } elseif (preg_match('/Trident/i', $u_agent)) {
            $bname = 'Internet Explorer';
            $ub = "MSIE";
        }

        // finally get the correct version number
        $known = array('Version', $ub, 'other');
        $pattern = '#(?<browser>' . join('|', $known) .
            ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
        if (!preg_match_all($pattern, $u_agent, $matches)) {
            // we have no matching number just continue
        }
        // see how many we have
        $i = count($matches['browser']);
        if ($i != 1) {
            //we will have two since we are not using 'other' argument yet
            //see if version is before or after the name
            if (strripos($u_agent, "Version") < strripos($u_agent, $ub)) {
                $version = $matches['version'][0];
            } else {
                $version = isset($matches['version'][1]) ? $matches['version'][1] : '';
            }
        } else {
            $version = $matches['version'][0];
        }

        // check if we have a number
        if ($version == null || $version == "") {
            $version = "";
        }

        return array(
            'browser-name'      => $bname,
            'browser-version'   => $version,
            'os'  => $platform,
        );
    }
    protected function fromError(int $severity)
    {
        switch ($severity) {
            case \E_DEPRECATED:
            case \E_USER_DEPRECATED:
            case \E_WARNING:
            case \E_USER_WARNING:
            case \E_CORE_WARNING:
            case \E_COMPILE_WARNING:
                return 'warning';
            case \E_ERROR:
            case \E_CORE_ERROR:
            case \E_COMPILE_ERROR:
            case \E_USER_ERROR:
            case \E_RECOVERABLE_ERROR:
            case \E_PARSE:
                return 'error';
            case \E_NOTICE:
            case \E_USER_NOTICE:
            case \E_STRICT:
                return 'notice';
            default:
                return 'error';
        }
    }
    public function getErrorTypeFromString($type)
    {
        $logType = array_search(strtolower($type), $this->error_types, true);
        if (!$logType) {
            $logType = 5;
        }
        return $logType;
    }

    public function getErrorTypeFromException($severity)
    {

        $errorType  = $this->fromError($severity);

        return $this->getErrorTypeFromString($errorType);
    }


    // protected function getUserIP()
    // {
    //     if (isset($_SERVER['HTTP_CLIENT_IP'])  && filter_var($_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)) {
    //         $ip = $_SERVER['HTTP_CLIENT_IP'];
    //     } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && filter_var($_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP)) {
    //         $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    //     } else {
    //         $ip = $_SERVER['REMOTE_ADDR'];
    //     }

    //     return $ip;
    // }

    function getUserIP()
    {
        // Get real visitor IP behind CloudFlare network
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
            $_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
            $_SERVER['HTTP_CLIENT_IP'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
        }
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = $_SERVER['REMOTE_ADDR'];

        if (filter_var($client, FILTER_VALIDATE_IP)) {
            $ip = $client;
        } elseif (filter_var($forward, FILTER_VALIDATE_IP)) {
            $ip = $forward;
        } else {
            $ip = $remote;
        }

        return $ip;
    }
}
