<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.itpathsolutions.com/
 * @since      1.0.0
 *
 * @package    Lighthouse
 * @subpackage Lighthouse/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Lighthouse
 * @subpackage Lighthouse/admin
 * @author     It Path Solutions <bhumip@itpathsolutions.co.in>
 */
class Lighthouse_Admin
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		$this->textdoamin = 'lighthouse';
	}
	private $option_name = 'lighthouse';
	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Lighthouse_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Lighthouse_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/lighthouse-admin.css', array(), $this->version, 'all');
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Lighthouse_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Lighthouse_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/lighthouse-admin.js', array('jquery'), $this->version, false);
	}
	/**
	 * Setting link on plugin page
	 *
	 * @since  1.0.0
	 * @access public
	 */
	public function lighthouse_action_links($links)
	{
		$settings_link = array(
			'<a href="' . admin_url('options-general.php?page=' . $this->plugin_name) . '">' . __('Lighthouse Settings', $this->plugin_name) . '</a>',
		);
		return array_merge($settings_link, $links);
	}
	/**
	 * Created Admin Menu.
	 *
	 * @since    1.0.0
	 */
	public function lighthouse_admin_menu()
	{
		add_options_page('Lighthouse Settings', 'Lighthouse Settings', 'manage_options', $this->plugin_name, array($this, 'lighthouse_settings'));
	}
	/**
	 * Register general section on pluign setting page
	 *
	 * @since  1.0.0
	 * @access public
	 */
	public function register_manifold_google_maps_settings()
	{
		// Add a General section
		add_settings_section(
			$this->option_name . '_general',
			'',
			array($this, $this->option_name . '_general_cb'),
			$this->plugin_name
		);
		// Add a project id field
		add_settings_field(
			$this->option_name . '_project_id',
			__('Project ID', $this->textdoamin),
			array($this, $this->option_name . '_project_cb'),
			$this->plugin_name,
			$this->option_name . '_general',
			array('label_for' => $this->option_name . '_project_id')
		);
		add_settings_field(
			$this->option_name . '_deliverable_id',
			__('Deliverable ID', $this->textdoamin),
			array($this, $this->option_name . '_deliverable_cb'),
			$this->plugin_name,
			$this->option_name . '_general',
			array('label_for' => $this->option_name . '_deliverable_id')
		);
		add_settings_field(
			$this->option_name . '_is_log_active',
			__('Active', $this->textdoamin),
			array($this, $this->option_name . '_is_log_active_cb'),
			$this->plugin_name,
			$this->option_name . '_general',
			array('label_for' => $this->option_name . '_log_active')
		);
		// Register the google key field
		register_setting($this->plugin_name, $this->option_name . '_project_id', 'string');
		register_setting($this->plugin_name, $this->option_name . '_deliverable_id', 'string');
		register_setting($this->plugin_name, $this->option_name . '_is_log_active', 'string');
	}

	/**
	 * Render the text for the general section
	 *
	 * @since  	1.0.0
	 * @access 	public
	 */
	public function lighthouse_general_cb()
	{
		//echo 'Lighthouse Settings';
	}

	/**
	 * Render the number input for this plugin
	 *
	 * @since  1.0.0
	 * @access public
	 */
	public function lighthouse_project_cb()
	{
		$get_project_id = get_option($this->option_name . '_project_id');
		echo '<input type="text" name="' . esc_attr($this->option_name) . '_project_id' . '" id="' . esc_attr($this->option_name) . '_project_id' . '" value="' . esc_attr($get_project_id) . '">';
	}

	public function lighthouse_deliverable_cb()
	{
		$get_deliverable_id = get_option($this->option_name . '_deliverable_id');
		echo '<input type="text" name="' . esc_attr($this->option_name) . '_deliverable_id' . '" id="' . esc_attr($this->option_name) . '_deliverable_id' . '" value="' . esc_attr($get_deliverable_id) . '">';
	}
	public function lighthouse_is_log_active_cb()
	{
?>
		<input type="checkbox" name="<?php echo esc_attr($this->option_name); ?>_is_log_active" id="<?php echo esc_attr($this->option_name); ?>_is_log_active" value="1" <?php checked(1, esc_attr(get_option($this->option_name . '_is_log_active')), true) ?>>
<?php

	}

	/**
	 * Admin Menu Page Content.
	 *
	 * @since    1.0.0
	 */
	public function lighthouse_settings()
	{
		include_once('partials/lighthouse-admin-display.php');
	}
	function lherrorHandler($errorNumber, $errorString, $errorFile, $errorLine)
	{
		$e = new Exception($errorString);
		include_once(plugin_dir_path(__FILE__) . 'Lighthouselog.php');
		$newLighthousel = new Lighthouselog();
		$return = $newLighthousel->add($e);
		
	}
	public function lighthouseInit()
	{
		set_error_handler(array($this, 'lherrorHandler'));
	}
	
}
